/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.gui.wizard.ActivityCardMapPanel;
import com.quantumdata.sct.gui.wizard.ActivityImageLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public abstract class ActivityMainPanel
extends JPanel
implements ActionListener {
    protected ComplianceTesterToolUI toolUI;
    private ActivityCardMapPanel m_cardPanel;
    private ActivityImageLabel m_stepLabel;
    private SCTButton m_nextButton;
    private SCTButton m_backButton;
    private SCTButton m_secNextButton;
    private SCTButton m_secBackButton;
    private SCTButton m_cancelButton;
    private SCTButton m_finishButton;
    private SCTButton m_stepsCountL;
    private JPanel m_buttonPanel;
    private boolean m_finishPressed;
    private boolean m_cancelPressed;

    public ActivityMainPanel(ComplianceTesterToolUI complianceTesterToolUI) {
        this.toolUI = complianceTesterToolUI;
        this.init();
    }

    public void dispose() {
    }

    private void init() {
        this.m_finishPressed = false;
        this.m_cancelPressed = false;
        this.setLayout(new BorderLayout());
        this.initButtonPanel();
        this.m_stepLabel = new ActivityImageLabel();
        JScrollPane jScrollPane = new JScrollPane(this.m_stepLabel);
        this.m_cardPanel = new ActivityCardMapPanel(this, this.m_stepLabel);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_cardPanel);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        jSplitPane.setDividerLocation(0.3);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerSize(0);
        this.add((Component)jSplitPane, "Center");
        this.add((Component)this.m_buttonPanel, "South");
    }

    public void showErrorMessage(String string) {
        MessageOptionPane.ShowErrorMessage(this, string, "ERROR!");
    }

    private void initButtonPanel() {
        this.m_buttonPanel = new JPanel(new GridBagLayout());
        this.m_buttonPanel.setBackground(SCTConstants.DIALOG_BG_COLOR);
        this.m_buttonPanel.add(this.getStepCountButton());
        this.m_buttonPanel.add(this.getSecBackButton());
        this.m_buttonPanel.add(this.getCancelButton());
        this.m_buttonPanel.add(this.getBackButton());
        this.m_buttonPanel.add(this.getNextButton());
        this.m_buttonPanel.add(this.getFinishButton());
        this.m_buttonPanel.add(this.getSecNextButton());
    }

    protected SCTButton getStepCountButton() {
        if (this.m_stepsCountL == null) {
            Dimension dimension = new Dimension(145, 36);
            this.m_stepsCountL = new SCTButton("No unit selected");
            this.m_stepsCountL.setSize(dimension);
            this.m_stepsCountL.setPreferredSize(dimension);
            this.m_stepsCountL.setEnabled(false);
        }
        return this.m_stepsCountL;
    }

    protected SCTButton getFinishButton() {
        if (this.m_finishButton == null) {
            this.m_finishButton = new SCTButton("Finish");
            this.m_finishButton.setMnemonic('F');
            this.m_finishButton.addActionListener(this);
            this.m_finishButton.setEnabled(false);
        }
        return this.m_finishButton;
    }

    protected SCTButton getCancelButton() {
        if (this.m_cancelButton == null) {
            this.m_cancelButton = new SCTButton("Cancel");
            this.m_cancelButton.setMnemonic('C');
            this.m_cancelButton.addActionListener(this);
            this.m_cancelButton.setEnabled(false);
        }
        return this.m_cancelButton;
    }

    protected SCTButton getNextButton() {
        if (this.m_nextButton == null) {
            this.m_nextButton = new SCTButton("Next");
            this.m_nextButton.setMnemonic('N');
            this.m_nextButton.addActionListener(this);
            this.m_nextButton.setEnabled(false);
        }
        return this.m_nextButton;
    }

    protected SCTButton getBackButton() {
        if (this.m_backButton == null) {
            this.m_backButton = new SCTButton("Back");
            this.m_backButton.setMnemonic('B');
            this.m_backButton.addActionListener(this);
            this.m_backButton.setEnabled(false);
        }
        return this.m_backButton;
    }

    protected SCTButton getSecNextButton() {
        if (this.m_secNextButton == null) {
            this.m_secNextButton = new SCTButton("Section >");
            this.m_secNextButton.setMnemonic('S');
            this.m_secNextButton.addActionListener(this);
            this.m_secNextButton.setEnabled(false);
        }
        return this.m_secNextButton;
    }

    protected SCTButton getSecBackButton() {
        if (this.m_secBackButton == null) {
            this.m_secBackButton = new SCTButton("< Section");
            this.m_secBackButton.setMnemonic('D');
            this.m_secBackButton.addActionListener(this);
            this.m_secBackButton.setEnabled(false);
        }
        return this.m_secBackButton;
    }

    public void nextButtonAction(ActionEvent actionEvent) {
        this.m_cardPanel.next();
    }

    public void backButtonAction(ActionEvent actionEvent) {
        this.m_cardPanel.previous();
    }

    public void nextSecButtonAction(ActionEvent actionEvent) {
        this.m_cardPanel.next();
    }

    public void backSecButtonAction(ActionEvent actionEvent) {
        this.m_cardPanel.previous();
    }

    public void cancelButtonAction(ActionEvent actionEvent) {
        this.setCancelPressed(true);
        this.dispose();
    }

    public ActivityCardItemPanel getCurrentCard() {
        return this.m_cardPanel.getCurrentCard();
    }

    public void finishButtonAction(ActionEvent actionEvent) {
        Component[] componentArray = this.m_cardPanel.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            ActivityCardItemPanel activityCardItemPanel = (ActivityCardItemPanel)componentArray[i];
            if (this.skip(activityCardItemPanel)) continue;
            if (!activityCardItemPanel.finishAction()) {
                activityCardItemPanel.setVisible(true);
                if (i == 0) {
                    this.m_backButton.setEnabled(false);
                    this.m_nextButton.setEnabled(true);
                    this.m_finishButton.setEnabled(false);
                }
                if (i == n - 1) {
                    this.m_nextButton.setEnabled(false);
                    this.m_finishButton.setEnabled(true);
                }
                return;
            }
            if (i == n - 1) {
                this.finishAction();
                this.dispose();
            }
            this.setFinishPressed(true);
        }
    }

    public boolean finishAction() {
        return true;
    }

    public boolean isFinishPressed() {
        return this.m_finishPressed;
    }

    public void setFinishPressed(boolean bl) {
        this.m_finishPressed = bl;
    }

    public boolean isCancelPressed() {
        return this.m_cancelPressed;
    }

    public void setCancelPressed(boolean bl) {
        this.m_cancelPressed = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_nextButton) {
            this.nextButtonAction(actionEvent);
        } else if (object == this.m_backButton) {
            this.backButtonAction(actionEvent);
        } else if (object == this.m_secNextButton) {
            this.nextSecButtonAction(actionEvent);
        } else if (object == this.m_secBackButton) {
            this.backSecButtonAction(actionEvent);
        } else if (object == this.m_cancelButton) {
            this.cancelButtonAction(actionEvent);
        } else if (object == this.m_finishButton) {
            this.finishButtonAction(actionEvent);
        }
    }

    public void addCard(String string, ActivityCardItemPanel activityCardItemPanel) {
        this.m_cardPanel.addMapCard(string, activityCardItemPanel);
    }

    public void clearCards() {
        this.m_cardPanel.clear();
    }

    public int getPageCount() {
        return this.m_stepLabel.getPageCount();
    }

    public int getPageIndex() {
        return this.m_stepLabel.getPageIndex();
    }

    public boolean isFirstPage() {
        return this.m_stepLabel.getPageIndex() == 0;
    }

    public boolean isLastPage() {
        return this.m_stepLabel.getPageIndex() == this.m_stepLabel.getPageCount() - 1;
    }

    public void setBackBtnEnabled(boolean bl) {
        this.m_backButton.setEnabled(bl);
    }

    public void setNextBtnEnabled(boolean bl) {
        this.m_nextButton.setEnabled(bl);
    }

    public void setFinishBtnEnabled(boolean bl) {
        this.m_finishButton.setEnabled(bl);
    }

    public void setCancelBtnEnabled(boolean bl) {
        this.m_cancelButton.setEnabled(bl);
    }

    public void setStepCountBtnEnabled(boolean bl) {
        this.m_stepsCountL.setEnabled(bl);
    }

    public void setBackSecBtnEnabled(boolean bl) {
        this.m_secBackButton.setEnabled(bl);
    }

    public void setNextSecBtnEnabled(boolean bl) {
        this.m_secNextButton.setEnabled(bl);
    }

    public void setBackBtnVisible(boolean bl) {
        this.m_backButton.setVisible(bl);
    }

    public void setNextBtnVisible(boolean bl) {
        this.m_nextButton.setVisible(bl);
    }

    public void setFinishBtnVisible(boolean bl) {
        this.m_finishButton.setVisible(bl);
    }

    public void setCancelBtnVisible(boolean bl) {
        this.m_cancelButton.setVisible(bl);
    }

    public void setStepCountBtnVisible(boolean bl) {
        this.m_stepsCountL.setVisible(bl);
    }

    public void setBackSecBtnVisible(boolean bl) {
        this.m_secBackButton.setVisible(bl);
    }

    public void setNextSecBtnVisible(boolean bl) {
        this.m_secNextButton.setVisible(bl);
    }

    public void validateBtn() {
        this.m_cardPanel.validateBtn();
    }

    public void showCard(String string) {
        this.m_cardPanel.showCard(string);
    }

    public boolean skip(ActivityCardItemPanel activityCardItemPanel) {
        return false;
    }
}

